/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.foundation.blockEntity;

import com.zurrtum.create.api.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.api.schematic.nbt.PartialSafeNBT;
import com.zurrtum.create.api.schematic.requirement.SpecialBlockEntityItemRequirement;
import com.zurrtum.create.content.schematics.requirement.ItemRequirement;
import com.zurrtum.create.foundation.advancement.AdvancementBehaviour;
import com.zurrtum.create.foundation.advancement.CreateTrigger;
import com.zurrtum.create.foundation.blockEntity.CachedRenderBBBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BehaviourType;
import com.zurrtum.create.foundation.blockEntity.behaviour.CachedInventoryBehaviour;
import com.zurrtum.create.foundation.utility.IInteractionChecker;
import com.zurrtum.create.ponder.api.VirtualBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9129;

public abstract class SmartBlockEntity
extends CachedRenderBBBlockEntity
implements PartialSafeNBT,
IInteractionChecker,
SpecialBlockEntityItemRequirement,
VirtualBlockEntity {
    private final Map<BehaviourType<?>, BlockEntityBehaviour<?>> behaviours = new Reference2ObjectArrayMap();
    protected int lazyTickRate;
    protected int lazyTickCounter;
    private boolean initialized = false;
    private boolean firstNbtRead = true;
    private boolean chunkUnloaded;
    private boolean virtualMode;

    public SmartBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
        ArrayList list = new ArrayList();
        this.addBehaviours(list);
        list.forEach((Consumer<BlockEntityBehaviour<?>>)((Consumer<BlockEntityBehaviour>)b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour<?>)b)));
        Iterator iterator = BlockEntityBehaviour.REGISTRY.get((Object)type).iterator();
        while (iterator.hasNext()) {
            Function factory = (Function)iterator.next();
            BlockEntityBehaviour behaviour = (BlockEntityBehaviour)factory.apply(this);
            this.behaviours.put(behaviour.getType(), behaviour);
        }
    }

    public abstract void addBehaviours(List<BlockEntityBehaviour<?>> var1);

    public void addBehavioursDeferred(List<BlockEntityBehaviour<?>> behaviours) {
    }

    public void initialize() {
        BlockEntityBehaviour behaviour;
        Function factory;
        Iterator iterator;
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            iterator = BlockEntityBehaviour.FIRST_READ_REGISTRY.get(this.method_11017()).iterator();
            while (iterator.hasNext()) {
                factory = (Function)iterator.next();
                behaviour = (BlockEntityBehaviour)factory.apply(this);
                this.behaviours.put(behaviour.getType(), behaviour);
            }
        }
        if (this.field_11863.method_8608()) {
            iterator = BlockEntityBehaviour.CLIENT_REGISTRY.get(this.method_11017()).iterator();
            while (iterator.hasNext()) {
                factory = (Function)iterator.next();
                behaviour = (BlockEntityBehaviour)factory.apply(this);
                this.behaviours.put(behaviour.getType(), behaviour);
            }
        }
        this.forEachBehaviour(BlockEntityBehaviour::initialize);
        this.lazyTick();
    }

    public void tick() {
        if (!this.initialized && this.method_11002()) {
            this.initialize();
            this.initialized = true;
        }
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
        this.forEachBehaviour(BlockEntityBehaviour::tick);
    }

    public void lazyTick() {
    }

    protected void write(class_11372 view, boolean clientPacket) {
        super.method_11007(view);
        this.forEachBehaviour(tb -> tb.write(view, clientPacket));
    }

    @Override
    public void writeSafe(class_11372 view) {
        super.method_11007(view);
        this.forEachBehaviour(tb -> {
            if (tb.isSafeNBT()) {
                tb.writeSafe(view);
            }
        });
    }

    protected void read(class_11368 view, boolean clientPacket) {
        if (this.firstNbtRead) {
            this.firstNbtRead = false;
            ArrayList list = new ArrayList();
            this.addBehavioursDeferred(list);
            list.forEach((Consumer<BlockEntityBehaviour<?>>)((Consumer<BlockEntityBehaviour>)b -> this.behaviours.put(b.getType(), (BlockEntityBehaviour<?>)b)));
            Iterator iterator = BlockEntityBehaviour.FIRST_READ_REGISTRY.get(this.method_11017()).iterator();
            while (iterator.hasNext()) {
                Function factory = (Function)iterator.next();
                BlockEntityBehaviour behaviour = (BlockEntityBehaviour)factory.apply(this);
                this.behaviours.put(behaviour.getType(), behaviour);
            }
        }
        super.method_11014(view);
        this.forEachBehaviour(tb -> tb.read(view, clientPacket));
    }

    protected void method_11014(class_11368 view) {
        this.read(view, false);
    }

    public void onChunkUnloaded() {
        this.chunkUnloaded = true;
    }

    public void method_11012() {
        super.method_11012();
        if (!this.chunkUnloaded) {
            this.remove();
        }
        this.invalidate();
    }

    public void invalidate() {
        this.forEachBehaviour(BlockEntityBehaviour::unload);
    }

    public void remove() {
    }

    public void destroy() {
        this.forEachBehaviour(BlockEntityBehaviour::destroy);
    }

    public void method_66473(class_2338 pos, class_2680 oldState) {
        super.method_66473(pos, oldState);
        this.destroy();
    }

    protected void method_11007(class_11372 view) {
        this.write(view, false);
    }

    @Override
    public final void readClient(class_11368 view) {
        this.read(view, true);
    }

    @Override
    public final void writeClient(class_11372 view) {
        this.write(view, true);
    }

    public <T extends BlockEntityBehaviour<?>> T getBehaviour(BehaviourType<T> type) {
        return (T)this.behaviours.get(type);
    }

    public void forEachBehaviour(Consumer<BlockEntityBehaviour<?>> action) {
        this.getAllBehaviours().forEach(action);
    }

    public Collection<BlockEntityBehaviour<?>> getAllBehaviours() {
        return this.behaviours.values();
    }

    public <T extends SmartBlockEntity> void attachBehaviourLate(BlockEntityBehaviour<T> behaviour) {
        BehaviourType<?> type = behaviour.getType();
        this.behaviours.values().forEach(b -> b.onBehaviourAdded(type, behaviour));
        this.behaviours.put(type, behaviour);
        behaviour.blockEntity = this;
        behaviour.initialize();
    }

    @Override
    public ItemRequirement getRequiredItems(class_2680 state) {
        return this.getAllBehaviours().stream().reduce(ItemRequirement.NONE, (r, b) -> r.union(b.getRequiredItems()), ItemRequirement::union);
    }

    public void removeBehaviour(BehaviourType<?> type) {
        BlockEntityBehaviour<?> remove = this.behaviours.remove(type);
        if (remove != null) {
            remove.unload();
        }
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    @Override
    public void markVirtual() {
        this.virtualMode = true;
    }

    @Override
    public boolean isVirtual() {
        return this.virtualMode;
    }

    public boolean isChunkUnloaded() {
        return this.chunkUnloaded;
    }

    @Override
    public boolean canPlayerUse(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void sendToMenu(class_9129 buffer) {
        buffer.method_10807(this.method_11016());
        buffer.method_10794((class_2520)this.method_16887((class_7225.class_7874)buffer.method_56349()));
    }

    public void refreshBlockState() {
        this.method_31664(this.method_10997().method_8320(this.method_11016()));
    }

    public void addAdvancementBehaviour(class_3222 player) {
        List<CreateTrigger> awardables = this.getAwardables();
        if (awardables != null) {
            this.behaviours.put(AdvancementBehaviour.TYPE, new AdvancementBehaviour(this, player, (CreateTrigger[])awardables.toArray(CreateTrigger[]::new)));
        }
    }

    public List<CreateTrigger> getAwardables() {
        return null;
    }

    public void award(CreateTrigger advancement) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public void awardIfNear(CreateTrigger advancement, int range) {
        AdvancementBehaviour behaviour = this.getBehaviour(AdvancementBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.awardPlayerIfNear(advancement, range);
        }
    }

    public void resetTransferCache() {
        CachedInventoryBehaviour<?> behaviour = this.getBehaviour(CachedInventoryBehaviour.TYPE);
        if (behaviour != null) {
            behaviour.reset();
        }
    }
}

